<?php
// add_attendance.php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}
$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

// get teacher classes (as earlier)
$classes = [];
$qr = mysqli_query($teach,"SELECT DISTINCT class_id FROM (
    SELECT class_id FROM teacher_class_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'
    UNION
    SELECT class_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'
) t");
while($r=mysqli_fetch_assoc($qr)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    if($c) $classes[$c['id']] = $c['name'];
}

$msg = "";
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save'])){
    $class_id = mysqli_real_escape_string($core,$_POST['class_id']);
    $date = mysqli_real_escape_string($core,$_POST['date']);
    // students list comes as student_id => status
    if(isset($_POST['status']) && is_array($_POST['status'])){
        // delete existing attendance for that class and date (simple approach)
        mysqli_query($core,"DELETE FROM attendance WHERE class_id='{$class_id}' AND date='{$date}'");
        foreach($_POST['status'] as $stid => $st) {
            $stid_s = mysqli_real_escape_string($core,$stid);
            $st_s = mysqli_real_escape_string($core,$st);
            $created_by = mysqli_real_escape_string($core,$tid);
            mysqli_query($core,"INSERT INTO attendance (student_id,date,status,class_id,created_by)
                VALUES ('$stid_s','$date','$st_s','$class_id','$created_by')");
        }
        $msg = "success|Attendance saved for {$date}";
    } else $msg = "error|No attendance data submitted";
}

$selected = $_POST['class_id'] ?? '';
$students = [];
if($selected){
    $res = mysqli_query($core,"SELECT * FROM students WHERE class_id='".mysqli_real_escape_string($core,$selected)."' ORDER BY name ASC");
    while($s=mysqli_fetch_assoc($res)) $students[]=$s;
}
?>
<style>
.attendance-container {
    padding: 32px;
}

.alert {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.alert-success {
    background: #d1fae5;
    color: #065f46;
    border: 1px solid #a7f3d0;
}

.alert-error {
    background: #fee2e2;
    color: #dc2626;
    border: 1px solid #fecaca;
}

.alert svg {
    flex-shrink: 0;
}

.filter-card {
    background: white;
    padding: 24px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.filter-card h3 {
    font-size: 16px;
    color: #374151;
    margin-bottom: 16px;
}

.form-select {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.attendance-form-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.form-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-input {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.attendance-table-container {
    overflow-x: auto;
    margin-top: 20px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.attendance-table {
    width: 100%;
    border-collapse: collapse;
}

.attendance-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.attendance-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.attendance-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
}

.attendance-table tbody tr:hover {
    background: #f9fafb;
}

.attendance-table td {
    padding: 16px;
}

.student-name-cell {
    display: flex;
    align-items: center;
    gap: 12px;
}

.student-avatar {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    flex-shrink: 0;
}

.status-options {
    display: flex;
    gap: 16px;
    flex-wrap: wrap;
}

.radio-option {
    display: flex;
    align-items: center;
    gap: 6px;
    cursor: pointer;
}

.radio-option input[type="radio"] {
    width: 18px;
    height: 18px;
    cursor: pointer;
    accent-color: #667eea;
}

.radio-option label {
    cursor: pointer;
    font-size: 14px;
    color: #374151;
    margin: 0;
}

.btn-save {
    padding: 14px 32px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn-save:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.4);
}

.form-footer {
    margin-top: 24px;
    padding-top: 20px;
    border-top: 1px solid #e5e7eb;
}

@media (max-width: 768px) {
    .attendance-container {
        padding: 20px;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .status-options {
        flex-direction: column;
        gap: 12px;
    }
    
    .attendance-table {
        min-width: 600px;
    }
}
</style>

<div class="attendance-container">
    <?php if($msg): 
        list($type, $text) = explode('|', $msg);
    ?>
    <div class="alert alert-<?php echo $type; ?>">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <?php if($type === 'success'): ?>
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
            <polyline points="22 4 12 14.01 9 11.01"/>
            <?php else: ?>
            <circle cx="12" cy="12" r="10"/>
            <line x1="12" y1="8" x2="12" y2="12"/>
            <line x1="12" y1="16" x2="12.01" y2="16"/>
            <?php endif; ?>
        </svg>
        <span><?php echo htmlspecialchars($text); ?></span>
    </div>
    <?php endif; ?>
    
    <div class="filter-card">
        <h3>Select Class</h3>
        <form method="post">
            <select name="class_id" class="form-select" required onchange="this.form.submit()">
                <option value="">-- Choose a class --</option>
                <?php foreach($classes as $id=>$n){ 
                    $sel = ($id==$selected)?'selected':''; 
                    echo "<option value='".htmlspecialchars($id)."' $sel>".htmlspecialchars($n)."</option>"; 
                } ?>
            </select>
        </form>
    </div>
    
    <?php if($selected): ?>
    <form method="post" class="attendance-form-card">
        <input type="hidden" name="class_id" value="<?php echo htmlspecialchars($selected); ?>">
        
        <div class="form-row">
            <div class="form-group">
                <label for="date">Attendance Date</label>
                <input type="date" id="date" name="date" class="form-input" value="<?php echo date('Y-m-d'); ?>" required>
            </div>
        </div>
        
        <?php if(count($students) > 0): ?>
        <div class="attendance-table-container">
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>Student</th>
                        <th>Mark Attendance</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($students as $s): ?>
                    <tr>
                        <td>
                            <div class="student-name-cell">
                                <div class="student-avatar">
                                    <?php echo strtoupper(substr($s['name'], 0, 1)); ?>
                                </div>
                                <div>
                                    <div style="color: #1f2937; font-weight: 500;"><?php echo htmlspecialchars($s['name']); ?></div>
                                    <div style="color: #6b7280; font-size: 13px;">Roll: <?php echo htmlspecialchars($s['roll_no']); ?></div>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="status-options">
                                <div class="radio-option">
                                    <input type="radio" id="present_<?php echo $s['id']; ?>" name="status[<?php echo $s['id']; ?>]" value="present" checked>
                                    <label for="present_<?php echo $s['id']; ?>">Present</label>
                                </div>
                                <div class="radio-option">
                                    <input type="radio" id="absent_<?php echo $s['id']; ?>" name="status[<?php echo $s['id']; ?>]" value="absent">
                                    <label for="absent_<?php echo $s['id']; ?>">Absent</label>
                                </div>
                                <div class="radio-option">
                                    <input type="radio" id="leave_<?php echo $s['id']; ?>" name="status[<?php echo $s['id']; ?>]" value="leave">
                                    <label for="leave_<?php echo $s['id']; ?>">Leave</label>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <div class="form-footer">
            <button name="save" type="submit" class="btn-save">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="20" height="20">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                    <polyline points="17 21 17 13 7 13 7 21"/>
                    <polyline points="7 3 7 8 15 8"/>
                </svg>
                Save Attendance
            </button>
        </div>
        <?php else: ?>
        <div class="empty-state">
            <p>No students found in this class.</p>
        </div>
        <?php endif; ?>
    </form>
    <?php endif; ?>
</div>
