<?php
// add_homework.php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}
$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

// classes teacher can handle (subject assignments)
$classes = [];
$qr = mysqli_query($teach,"SELECT DISTINCT class_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'");
while($r=mysqli_fetch_assoc($qr)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    if($c) $classes[$c['id']] = $c['name'];
}

$msg = "";
$selected_class = $_POST['class_id'] ?? '';
$subjects_for_class = [];
if($selected_class){
    $sq = mysqli_query($teach,"SELECT subject_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."' AND class_id='".mysqli_real_escape_string($teach,$selected_class)."'");
    while($r=mysqli_fetch_assoc($sq)){
        $sid = mysqli_real_escape_string($core,$r['subject_id']);
        $s = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM subjects WHERE id='{$sid}'"));
        if($s) $subjects_for_class[$s['id']] = $s['name'];
    }
}

if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save'])){
    $class_id = mysqli_real_escape_string($core,$_POST['class_id']);
    $subject_id = mysqli_real_escape_string($core,$_POST['subject_id']);
    $description = mysqli_real_escape_string($core,$_POST['description']);
    $due_date = mysqli_real_escape_string($core,$_POST['due_date']);
    $created_by = mysqli_real_escape_string($core,$tid);
    $created_at = date("Y-m-d H:i:s");
    
    $ins = mysqli_query($core,"INSERT INTO homework (class_id,subject_id,description,due_date,created_by,created_at)
        VALUES ('$class_id','$subject_id','$description','$due_date','$created_by','$created_at')");
    if($ins) $msg = "success|Homework posted successfully";
    else $msg = "error|Error: ".mysqli_error($core);
}
?>
<style>
.homework-container {
    padding: 32px;
}

.alert {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.alert-success {
    background: #d1fae5;
    color: #065f46;
    border: 1px solid #a7f3d0;
}

.alert-error {
    background: #fee2e2;
    color: #dc2626;
    border: 1px solid #fecaca;
}

.alert svg {
    flex-shrink: 0;
}

.homework-form-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select,
.form-input,
.form-textarea {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus,
.form-input:focus,
.form-textarea:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.form-textarea {
    min-height: 150px;
    resize: vertical;
}

.btn-post {
    padding: 14px 32px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn-post:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
}

.form-footer {
    margin-top: 24px;
    padding-top: 20px;
    border-top: 1px solid #e5e7eb;
}

.info-box {
    background: #f0f9ff;
    border: 1px solid #bae6fd;
    border-left: 4px solid #0ea5e9;
    padding: 16px;
    border-radius: 10px;
    margin-bottom: 24px;
    display: flex;
    align-items: start;
    gap: 12px;
}

.info-box svg {
    flex-shrink: 0;
    color: #0ea5e9;
    margin-top: 2px;
}

.info-box-content h4 {
    color: #0c4a6e;
    margin-bottom: 4px;
    font-size: 14px;
}

.info-box-content p {
    color: #075985;
    font-size: 13px;
}

@media (max-width: 768px) {
    .homework-container {
        padding: 20px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="homework-container">
    <?php if($msg): 
        list($type, $text) = explode('|', $msg);
    ?>
    <div class="alert alert-<?php echo $type; ?>">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <?php if($type === 'success'): ?>
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
            <polyline points="22 4 12 14.01 9 11.01"/>
            <?php else: ?>
            <circle cx="12" cy="12" r="10"/>
            <line x1="12" y1="8" x2="12" y2="12"/>
            <line x1="12" y1="16" x2="12.01" y2="16"/>
            <?php endif; ?>
        </svg>
        <span><?php echo htmlspecialchars($text); ?></span>
    </div>
    <?php endif; ?>
    
    <div class="info-box">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <circle cx="12" cy="12" r="10"/>
            <line x1="12" y1="16" x2="12" y2="12"/>
            <line x1="12" y1="8" x2="12.01" y2="8"/>
        </svg>
        <div class="info-box-content">
            <h4>Post Homework</h4>
            <p>Select a class and subject to post homework assignments for your students</p>
        </div>
    </div>
    
    <form method="post" class="homework-form-card">
        <div class="form-grid">
            <div class="form-group">
                <label for="class_id">Class</label>
                <select name="class_id" id="class_id" class="form-select" onchange="this.form.submit()" required>
                    <option value="">-- Select Class --</option>
                    <?php foreach($classes as $id=>$n){ 
                        $sel = ($id==$selected_class)?'selected':''; 
                        echo "<option value='".htmlspecialchars($id)."' $sel>".htmlspecialchars($n)."</option>"; 
                    } ?>
                </select>
            </div>
            
            <?php if($selected_class): ?>
            <div class="form-group">
                <label for="subject_id">Subject</label>
                <select name="subject_id" id="subject_id" class="form-select" required>
                    <option value="">-- Select Subject --</option>
                    <?php foreach($subjects_for_class as $sid=>$sname){ 
                        echo "<option value='".htmlspecialchars($sid)."'>".htmlspecialchars($sname)."</option>"; 
                    } ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="due_date">Due Date</label>
                <input type="date" id="due_date" name="due_date" class="form-input">
            </div>
            <?php endif; ?>
        </div>
        
        <?php if($selected_class): ?>
        <div class="form-group">
            <label for="description">Homework Description</label>
            <textarea id="description" name="description" class="form-textarea" placeholder="Enter homework details and instructions..." required></textarea>
        </div>
        
        <div class="form-footer">
            <button name="save" type="submit" class="btn-post">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="20" height="20">
                    <path d="M12 20h9"/>
                    <path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"/>
                </svg>
                Post Homework
            </button>
        </div>
        <?php endif; ?>
    </form>
</div>
