<?php
// add_marks.php
if (!isset($_SESSION['teacher_id'])) { 
    echo "Not authorized"; 
    exit;
}
$tid = $_SESSION['teacher_id'];

// DB CONNECTIONS
$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");

if(!$teach || !$core){
    die("Database connection error");
}

// FETCH TEACHER ASSIGNED CLASSES
$classes = [];
$q1 = mysqli_query($teach,
    "SELECT DISTINCT class_id
      FROM teacher_subject_assignments
      WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'");

while($r = mysqli_fetch_assoc($q1)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='$cid'"));
    if($c){
        $classes[$c['id']] = $c['name'];
    }
}

// FORM VALUES
$msg = "";
$selected_class   = $_POST['class_id']   ?? '';
$selected_subject = $_POST['subject_id'] ?? '';
$term             = $_POST['term']       ?? '';

// FETCH SUBJECTS FOR THIS TEACHER IN SELECTED CLASS
$subjects_for_class = [];
if($selected_class){
    $q2 = mysqli_query($teach,
        "SELECT subject_id
          FROM teacher_subject_assignments
          WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."' 
           AND class_id='".mysqli_real_escape_string($teach,$selected_class)."'");
    
    while($s = mysqli_fetch_assoc($q2)){
        $sid = mysqli_real_escape_string($core,$s['subject_id']);
        $sub = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM subjects WHERE id='$sid'"));
        if($sub){
            $subjects_for_class[$sub['id']] = $sub['name'];
        }
    }
}

// FETCH STUDENTS
$students = [];
if($selected_class){
    $q3 = mysqli_query($core,
        "SELECT id,name
          FROM students
          WHERE class_id='".mysqli_real_escape_string($core,$selected_class)."'
         ORDER BY name ASC");
    
    while($st = mysqli_fetch_assoc($q3)){
        $students[] = $st;
    }
}

// SAVE MARKS
if(isset($_POST['save'])){
    if(empty($selected_class) || empty($selected_subject) || empty($term)){
        $msg = "warning|Please fill all fields";
    } else {
        foreach($_POST['marks'] as $sid => $m){
            $sid_clean = mysqli_real_escape_string($core,$sid);
            $m_clean   = intval($m);
            $term_clean = mysqli_real_escape_string($core,$term);
            $sub_clean  = mysqli_real_escape_string($core,$selected_subject);
            $created_by = mysqli_real_escape_string($core,$tid);
            
            // Remove previous mark if exists
            mysqli_query($core,
                "DELETE FROM marks
                  WHERE student_id='$sid_clean'
                    AND subject_id='$sub_clean'
                   AND term='$term_clean'");
            
            // Insert new mark
            mysqli_query($core,
                "INSERT INTO marks (student_id,subject_id,marks,term,created_by)
                 VALUES('$sid_clean','$sub_clean','$m_clean','$term_clean','$created_by')");
        }
        $msg = "success|Marks saved successfully";
    }
}
?>
<style>
.marks-container {
    padding: 32px;
}

.alert {
    padding: 16px 20px;
    border-radius: 12px;
    margin-bottom: 24px;
    display: flex;
    align-items: center;
    gap: 12px;
    animation: slideIn 0.3s ease;
}

@keyframes slideIn {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.alert-success {
    background: #d1fae5;
    color: #065f46;
    border: 1px solid #a7f3d0;
}

.alert-warning {
    background: #fef3c7;
    color: #92400e;
    border: 1px solid #fde68a;
}

.alert svg {
    flex-shrink: 0;
}

.form-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 24px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select,
.form-input {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus,
.form-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.marks-table-container {
    overflow-x: auto;
    margin-top: 24px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
}

.marks-table {
    width: 100%;
    border-collapse: collapse;
}

.marks-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.marks-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.marks-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
}

.marks-table tbody tr:hover {
    background: #f9fafb;
}

.marks-table td {
    padding: 16px;
}

.student-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.student-avatar {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    flex-shrink: 0;
}

.marks-input {
    width: 100px;
    padding: 10px;
    border: 2px solid #e5e7eb;
    border-radius: 8px;
    font-size: 15px;
    text-align: center;
    transition: all 0.2s ease;
}

.marks-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.btn-save {
    padding: 14px 32px;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 16px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn-save:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.4);
}

.form-footer {
    margin-top: 24px;
    padding-top: 20px;
    border-top: 1px solid #e5e7eb;
}

.empty-state {
    text-align: center;
    padding: 48px 24px;
}

.empty-icon {
    width: 80px;
    height: 80px;
    background: #f3f4f6;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 16px;
}

.empty-icon svg {
    width: 40px;
    height: 40px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 18px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 14px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .marks-container {
        padding: 20px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .marks-table {
        min-width: 500px;
    }
}
</style>

<div class="marks-container">
    <?php if($msg): 
        list($type, $text) = explode('|', $msg);
    ?>
    <div class="alert alert-<?php echo $type; ?>">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
            <?php if($type === 'success'): ?>
            <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
            <polyline points="22 4 12 14.01 9 11.01"/>
            <?php else: ?>
            <circle cx="12" cy="12" r="10"/>
            <line x1="12" y1="8" x2="12" y2="12"/>
            <line x1="12" y1="16" x2="12.01" y2="16"/>
            <?php endif; ?>
        </svg>
        <span><?php echo htmlspecialchars($text); ?></span>
    </div>
    <?php endif; ?>
    
    <form method="post" class="form-card">
        <div class="form-grid">
            <div class="form-group">
                <label for="class_id">Select Class</label>
                <select name="class_id" id="class_id" class="form-select" onchange="this.form.submit()">
                    <option value="">-- Select Class --</option>
                    <?php foreach($classes as $id=>$name): ?>
                        <option value="<?php echo $id; ?>" <?php echo ($selected_class==$id?'selected':''); ?>>
                            <?php echo htmlspecialchars($name); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <?php if($selected_class): ?>
            <div class="form-group">
                <label for="subject_id">Select Subject</label>
                <select name="subject_id" id="subject_id" class="form-select">
                    <option value="">-- Select Subject --</option>
                    <?php foreach($subjects_for_class as $sid=>$sname): ?>
                        <option value="<?php echo $sid; ?>" <?php echo ($selected_subject==$sid?'selected':''); ?>>
                            <?php echo htmlspecialchars($sname); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="term">Term</label>
                <input type="text" id="term" name="term" class="form-input" value="<?php echo htmlspecialchars($term); ?>" placeholder="e.g. Midterm, Final" required>
            </div>
            <?php endif; ?>
        </div>
        
        <?php if($selected_class && count($students)): ?>
        <div class="marks-table-container">
            <table class="marks-table">
                <thead>
                    <tr>
                        <th>Student Name</th>
                        <th>Marks (0–100)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($students as $s): ?>
                    <tr>
                        <td>
                            <div class="student-info">
                                <div class="student-avatar">
                                    <?php echo strtoupper(substr($s['name'], 0, 1)); ?>
                                </div>
                                <div style="color: #1f2937; font-weight: 500;"><?php echo htmlspecialchars($s['name']); ?></div>
                            </div>
                        </td>
                        <td>
                            <input type="number" name="marks[<?php echo $s['id']; ?>]" class="marks-input" min="0" max="100" placeholder="0">
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <div class="form-footer">
            <button type="submit" name="save" class="btn-save">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="20" height="20">
                    <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                    <polyline points="17 21 17 13 7 13 7 21"/>
                    <polyline points="7 3 7 8 15 8"/>
                </svg>
                Save Marks
            </button>
        </div>
        <?php elseif($selected_class): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                    <circle cx="9" cy="7" r="4"/>
                </svg>
            </div>
            <h3>No Students Found</h3>
            <p>There are no students in this class</p>
        </div>
        <?php endif; ?>
    </form>
</div>
