<?php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}

$core = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$core) die("DB Error");

// fetch classes for dropdown
$classes_res = mysqli_query($core,"SELECT id,name FROM classes ORDER BY name ASC");
$classes = [];
while($c=mysqli_fetch_assoc($classes_res)) {
    $classes[$c['id']] = $c['name'];
}

$class_id = $_GET['class_id'] ?? '';
$term = $_GET['term'] ?? '';

$students = [];
$marks = [];

if($class_id){
    $class_id = mysqli_real_escape_string($core,$class_id);
    // fetch students of this class
    $rs = mysqli_query($core,"SELECT id,name FROM students WHERE class_id='$class_id' ORDER BY name ASC");
    while($s=mysqli_fetch_assoc($rs)) $students[$s['id']] = $s['name'];
}

if($class_id && $term){
    $term = mysqli_real_escape_string($core,$term);
    // fetch marks for these students in this term
    if(count($students) > 0) {
        $marks_res = mysqli_query($core,"SELECT m.*, s.name as subject_name, m.student_id
                                     FROM marks m
                                     LEFT JOIN subjects s ON m.subject_id=s.id
                                     WHERE m.student_id IN ('".implode("','",array_keys($students))."')
                                     AND m.term='$term'
                                    ORDER BY m.student_id, s.name ASC");
        while($m=mysqli_fetch_assoc($marks_res)){
            $marks[$m['student_id']][] = $m;
        }
    }
}
?>
<style>
.report-container {
    padding: 32px;
}

.filter-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select,
.form-input {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus,
.form-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.btn-primary {
    padding: 12px 24px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
}

.report-card {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid #e5e7eb;
}

.report-table {
    width: 100%;
    border-collapse: collapse;
}

.report-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.report-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.report-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
}

.report-table tbody tr:hover {
    background: #f9fafb;
}

.report-table td {
    padding: 16px;
    color: #374151;
    font-size: 14px;
}

.marks-badge {
    display: inline-block;
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 13px;
}

.marks-badge.high {
    background: #d1fae5;
    color: #065f46;
}

.marks-badge.medium {
    background: #fef3c7;
    color: #92400e;
}

.marks-badge.low {
    background: #fee2e2;
    color: #991b1b;
}

.empty-state {
    text-align: center;
    padding: 64px 24px;
}

.empty-icon {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.empty-icon svg {
    width: 50px;
    height: 50px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 20px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 15px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .report-container {
        padding: 20px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .report-card {
        overflow-x: auto;
    }
    
    .report-table {
        min-width: 600px;
    }
}
</style>

<div class="report-container">
    <div class="filter-card">
        <form method="get">
            <input type="hidden" name="page" value="report_class_marks">
            <div class="form-grid">
                <div class="form-group">
                    <label for="class_id">Select Class</label>
                    <select name="class_id" id="class_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- Select Class --</option>
                        <?php foreach($classes as $cid=>$cname){
                            $sel = ($cid==$class_id)?'selected':'';
                            echo "<option value='".htmlspecialchars($cid)."' $sel>".htmlspecialchars($cname)."</option>";
                        } ?>
                    </select>
                </div>
                
                <?php if($class_id): ?>
                <div class="form-group">
                    <label for="term">Term</label>
                    <input type="text" id="term" name="term" class="form-input" value="<?php echo htmlspecialchars($term); ?>" placeholder="e.g. Midterm, Final">
                </div>
                <?php endif; ?>
            </div>
            
            <?php if($class_id): ?>
            <button type="submit" class="btn-primary">Show Report</button>
            <?php endif; ?>
        </form>
    </div>
    
    <?php if($class_id && $term && count($students)): ?>
    <div class="report-card">
        <table class="report-table">
            <thead>
                <tr>
                    <th>Student Name</th>
                    <th>Subject</th>
                    <th>Marks</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($students as $sid=>$sname):
                    if(isset($marks[$sid])){
                        foreach($marks[$sid] as $m){
                            $mark_val = intval($m['marks']);
                            $badge_class = $mark_val >= 70 ? 'high' : ($mark_val >= 40 ? 'medium' : 'low');
                            echo "<tr><td>{$sname}</td><td>{$m['subject_name']}</td><td><span class='marks-badge {$badge_class}'>{$m['marks']}</span></td></tr>";
                        }
                    } else {
                        echo "<tr><td>{$sname}</td><td colspan='2' style='color: #9ca3af;'>No marks recorded</td></tr>";
                    }
                endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php elseif($class_id && $term): ?>
    <div class="empty-state">
        <div class="empty-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                <polyline points="14 2 14 8 20 8"/>
            </svg>
        </div>
        <h3>No Data Available</h3>
        <p>No students or marks found for this class and term</p>
    </div>
    <?php endif; ?>
</div>
