<?php
// teacher_dashboard.php
session_start();
if(!isset($_SESSION['teacher_id'])){
    header("Location: teacher_login.php");
    exit;
}

$page = $_GET['page'] ?? 'home';
$teacher_name = $_SESSION['teacher_name'] ?? 'Teacher';
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Teacher Dashboard - TheVK School</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Arial, sans-serif;
    background: #f3f4f6;
    color: #1f2937;
}

.dashboard {
    display: flex;
    min-height: 100vh;
}

/* Sidebar */
.sidebar {
    width: 280px;
    background: linear-gradient(180deg, #1e293b 0%, #0f172a 100%);
    color: white;
    position: fixed;
    height: 100vh;
    overflow-y: auto;
    transition: transform 0.3s ease;
    z-index: 1000;
}

.sidebar-header {
    padding: 24px 20px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.brand {
    display: flex;
    align-items: center;
    gap: 12px;
}

.brand-logo {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.brand-logo svg {
    width: 24px;
    height: 24px;
}

.brand-text h1 {
    font-size: 18px;
    margin-bottom: 2px;
}

.brand-text p {
    font-size: 12px;
    opacity: 0.7;
}

.teacher-info {
    padding: 20px;
    background: rgba(255, 255, 255, 0.05);
    margin: 20px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.teacher-avatar {
    width: 48px;
    height: 48px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.teacher-avatar svg {
    width: 24px;
    height: 24px;
}

.teacher-details h3 {
    font-size: 15px;
    margin-bottom: 4px;
}

.teacher-details p {
    font-size: 13px;
    opacity: 0.7;
}

.nav-menu {
    padding: 20px 0;
}

.nav-section {
    margin-bottom: 24px;
}

.nav-section-title {
    padding: 0 20px 8px;
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 1px;
    opacity: 0.5;
}

.nav-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 20px;
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    transition: all 0.2s ease;
    position: relative;
}

.nav-item:hover {
    background: rgba(255, 255, 255, 0.08);
    color: white;
}

.nav-item.active {
    background: rgba(102, 126, 234, 0.2);
    color: white;
    border-left: 3px solid #667eea;
}

.nav-item svg {
    width: 20px;
    height: 20px;
    flex-shrink: 0;
}

.logout-btn {
    margin: 20px;
    padding: 12px 20px;
    background: rgba(239, 68, 68, 0.1);
    border: 1px solid rgba(239, 68, 68, 0.3);
    color: #fca5a5;
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    transition: all 0.2s ease;
}

.logout-btn:hover {
    background: rgba(239, 68, 68, 0.2);
}

/* Main Content */
.main-content {
    flex: 1;
    margin-left: 280px;
    transition: margin-left 0.3s ease;
}

.topbar {
    background: white;
    padding: 16px 24px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    justify-content: space-between;
    position: sticky;
    top: 0;
    z-index: 100;
}

.menu-toggle {
    display: none;
    background: none;
    border: none;
    cursor: pointer;
    padding: 8px;
}

.menu-toggle svg {
    width: 24px;
    height: 24px;
    color: #374151;
}

.topbar-title h2 {
    font-size: 20px;
    color: #1f2937;
}

.topbar-actions {
    display: flex;
    align-items: center;
    gap: 12px;
}

.content-area {
    padding: 24px;
}

.content-frame {
    background: white;
    border-radius: 16px;
    box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    min-height: calc(100vh - 120px);
}

/* Mobile Styles */
@media (max-width: 768px) {
    .sidebar {
        transform: translateX(-100%);
    }
    
    .sidebar.active {
        transform: translateX(0);
    }
    
    .main-content {
        margin-left: 0;
    }
    
    .menu-toggle {
        display: block;
    }
    
    .topbar {
        padding: 12px 16px;
    }
    
    .topbar-title h2 {
        font-size: 18px;
    }
    
    .content-area {
        padding: 16px;
    }
}

.overlay {
    display: none;
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 999;
}

.overlay.active {
    display: block;
}

/* Scrollbar */
.sidebar::-webkit-scrollbar {
    width: 6px;
}

.sidebar::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.05);
}

.sidebar::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.2);
    border-radius: 3px;
}

.sidebar::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.3);
}
</style>
</head>
<body>

<div class="dashboard">
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="brand">
                <div class="brand-logo">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 14l9-5-9-5-9 5 9 5z"/>
                        <path d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z"/>
                    </svg>
                </div>
                <div class="brand-text">
                    <h1>TheVK</h1>
                    <p>School Portal</p>
                </div>
            </div>
        </div>
        
        <div class="teacher-info">
            <div class="teacher-avatar">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                    <circle cx="12" cy="7" r="4"/>
                </svg>
            </div>
            <div class="teacher-details">
                <h3><?php echo htmlspecialchars($teacher_name); ?></h3>
                <p>Teacher</p>
            </div>
        </div>
        
        <nav class="nav-menu">
            <div class="nav-section">
                <div class="nav-section-title">Main</div>
                <a href="?page=home" class="nav-item <?php echo $page==='home'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        <polyline points="9 22 9 12 15 12 15 22"/>
                    </svg>
                    <span>Dashboard</span>
                </a>
                <a href="?page=view_students" class="nav-item <?php echo $page==='view_students'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                        <circle cx="9" cy="7" r="4"/>
                        <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                        <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                    </svg>
                    <span>View Students</span>
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Attendance & Marks</div>
                <a href="?page=add_attendance" class="nav-item <?php echo $page==='add_attendance'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M9 11l3 3L22 4"/>
                        <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
                    </svg>
                    <span>Add Attendance</span>
                </a>
                <a href="?page=add_marks" class="nav-item <?php echo $page==='add_marks'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                        <polyline points="10 9 9 9 8 9"/>
                    </svg>
                    <span>Add Marks</span>
                </a>
                <a href="?page=view_marks" class="nav-item <?php echo $page==='view_marks'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>
                        <circle cx="12" cy="12" r="3"/>
                    </svg>
                    <span>View Marks</span>
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Homework</div>
                <a href="?page=add_homework" class="nav-item <?php echo $page==='add_homework'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M12 20h9"/>
                        <path d="M16.5 3.5a2.121 2.121 0 0 1 3 3L7 19l-4 1 1-4L16.5 3.5z"/>
                    </svg>
                    <span>Add Homework</span>
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Reports</div>
                <a href="?page=report_class_marks" class="nav-item <?php echo $page==='report_class_marks'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                        <polyline points="14 2 14 8 20 8"/>
                        <line x1="16" y1="13" x2="8" y2="13"/>
                        <line x1="16" y1="17" x2="8" y2="17"/>
                    </svg>
                    <span>Class Marks Report</span>
                </a>
                <a href="?page=report_student_marks" class="nav-item <?php echo $page==='report_student_marks'?'active':''; ?>">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2"/>
                        <rect x="8" y="2" width="8" height="4" rx="1" ry="1"/>
                    </svg>
                    <span>Student Marks Report</span>
                </a>
            </div>
        </nav>
        
        <button class="logout-btn" onclick="if(confirm('Are you sure you want to logout?')) window.location.href='logout_teacher.php'">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="20" height="20">
                <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
                <polyline points="16 17 21 12 16 7"/>
                <line x1="21" y1="12" x2="9" y2="12"/>
            </svg>
            Logout
        </button>
    </aside>
    
    <!-- Overlay for mobile -->
    <div class="overlay" id="overlay" onclick="closeSidebar()"></div>
    
    <!-- Main Content -->
    <main class="main-content">
        <div class="topbar">
            <button class="menu-toggle" onclick="toggleSidebar()">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="12" x2="21" y2="12"/>
                    <line x1="3" y1="6" x2="21" y2="6"/>
                    <line x1="3" y1="18" x2="21" y2="18"/>
                </svg>
            </button>
            <div class="topbar-title">
                <h2>
                    <?php
                    $titles = [
                        'home' => 'Dashboard',
                        'view_students' => 'View Students',
                        'add_attendance' => 'Add Attendance',
                        'add_marks' => 'Add Marks',
                        'view_marks' => 'View Marks',
                        'add_homework' => 'Add Homework',
                        'report_class_marks' => 'Class Marks Report',
                        'report_student_marks' => 'Student Marks Report'
                    ];
                    echo $titles[$page] ?? 'Dashboard';
                    ?>
                </h2>
            </div>
            <div class="topbar-actions">
                <!-- Additional actions can go here -->
            </div>
        </div>
        
        <div class="content-area">
            <div class="content-frame">
                <?php
                switch($page) {
                    case 'home':
                        include 'teacher_home.php';
                        break;
                    case 'view_students':
                        include 'view_students.php';
                        break;
                    case 'add_attendance':
                        include 'add_attendance.php';
                        break;
                    case 'add_marks':
                        include 'add_marks.php';
                        break;
                    case 'view_marks':
                        include 'view_marks.php';
                        break;
                    case 'add_homework':
                        include 'add_homework.php';
                        break;
                    case 'report_class_marks':
                        include 'report_class_marks.php';
                        break;
                    case 'report_student_marks':
                        include 'report_student_marks.php';
                        break;
                    default:
                        include 'teacher_home.php';
                }
                ?>
            </div>
        </div>
    </main>
</div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    sidebar.classList.toggle('active');
    overlay.classList.toggle('active');
}

function closeSidebar() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    sidebar.classList.remove('active');
    overlay.classList.remove('active');
}
</script>

</body>
</html>
