<?php
// teacher_home.php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}

$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

// classes where teacher is class teacher
$ct = mysqli_query($teach, "SELECT class_id FROM teacher_class_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'");
$class_list = [];
while($r=mysqli_fetch_assoc($ct)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    if($c) $class_list[] = $c;
}

// subjects where teacher is subject teacher
$st = mysqli_query($teach, "SELECT class_id, subject_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'");
$subject_list = [];
while($r=mysqli_fetch_assoc($st)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $sid = mysqli_real_escape_string($core,$r['subject_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    $s = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM subjects WHERE id='{$sid}'"));
    if($s) $subject_list[] = ['subject'=>$s,'class'=>$c];
}
?>
<style>
.home-container {
    padding: 32px;
}

.welcome-banner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 32px;
    border-radius: 16px;
    margin-bottom: 32px;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.welcome-banner h1 {
    font-size: 28px;
    margin-bottom: 8px;
}

.welcome-banner p {
    font-size: 16px;
    opacity: 0.9;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 24px;
    margin-bottom: 32px;
}

.stat-card {
    background: white;
    padding: 24px;
    border-radius: 12px;
    border: 1px solid #e5e7eb;
    display: flex;
    align-items: center;
    gap: 16px;
    transition: all 0.3s ease;
}

.stat-card:hover {
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    transform: translateY(-2px);
}

.stat-icon {
    width: 56px;
    height: 56px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    flex-shrink: 0;
}

.stat-icon.purple {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.stat-icon.blue {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
}

.stat-icon.green {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
}

.stat-icon svg {
    width: 28px;
    height: 28px;
    color: white;
}

.stat-info h3 {
    font-size: 32px;
    margin-bottom: 4px;
    color: #1f2937;
}

.stat-info p {
    font-size: 14px;
    color: #6b7280;
}

.section-card {
    background: white;
    border-radius: 16px;
    padding: 28px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.section-header {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 20px;
    padding-bottom: 16px;
    border-bottom: 2px solid #f3f4f6;
}

.section-icon {
    width: 40px;
    height: 40px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.section-icon svg {
    width: 22px;
    height: 22px;
    color: white;
}

.section-header h2 {
    font-size: 20px;
    color: #1f2937;
}

.assignment-grid {
    display: grid;
    gap: 12px;
}

.assignment-item {
    background: #f9fafb;
    padding: 16px 20px;
    border-radius: 10px;
    border-left: 4px solid #667eea;
    display: flex;
    align-items: center;
    justify-content: space-between;
    transition: all 0.2s ease;
}

.assignment-item:hover {
    background: #f3f4f6;
    transform: translateX(4px);
}

.assignment-info {
    display: flex;
    align-items: center;
    gap: 12px;
}

.assignment-badge {
    width: 36px;
    height: 36px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 14px;
}

.assignment-details h4 {
    font-size: 15px;
    color: #1f2937;
    margin-bottom: 4px;
}

.assignment-details p {
    font-size: 13px;
    color: #6b7280;
}

.assignment-id {
    font-size: 13px;
    color: #9ca3af;
    background: white;
    padding: 4px 12px;
    border-radius: 6px;
}

.empty-state {
    text-align: center;
    padding: 48px 24px;
}

.empty-icon {
    width: 80px;
    height: 80px;
    background: #f3f4f6;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 16px;
}

.empty-icon svg {
    width: 40px;
    height: 40px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 18px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 14px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .home-container {
        padding: 20px;
    }
    
    .welcome-banner {
        padding: 24px;
    }
    
    .welcome-banner h1 {
        font-size: 24px;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
        gap: 16px;
    }
    
    .section-card {
        padding: 20px;
    }
    
    .assignment-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
}
</style>

<div class="home-container">
    <div class="welcome-banner">
        <h1>Welcome back, <?php echo htmlspecialchars($teacher_name); ?>! 👋</h1>
        <p>Here's your teaching overview for today</p>
    </div>
    
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon purple">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
            </div>
            <div class="stat-info">
                <h3><?php echo count($class_list); ?></h3>
                <p>Class Teacher</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon blue">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/>
                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/>
                </svg>
            </div>
            <div class="stat-info">
                <h3><?php echo count($subject_list); ?></h3>
                <p>Subject Assignments</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon green">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                    <line x1="16" y1="2" x2="16" y2="6"/>
                    <line x1="8" y1="2" x2="8" y2="6"/>
                    <line x1="3" y1="10" x2="21" y2="10"/>
                </svg>
            </div>
            <div class="stat-info">
                <h3><?php echo date('d'); ?></h3>
                <p><?php echo date('F Y'); ?></p>
            </div>
        </div>
    </div>
    
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                    <polyline points="9 22 9 12 15 12 15 22"/>
                </svg>
            </div>
            <h2>Assigned as Class Teacher</h2>
        </div>
        
        <?php if(count($class_list)==0): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                </svg>
            </div>
            <h3>No Class Assignments</h3>
            <p>You are not currently assigned as a class teacher</p>
        </div>
        <?php else: ?>
        <div class="assignment-grid">
            <?php foreach($class_list as $c): ?>
            <div class="assignment-item">
                <div class="assignment-info">
                    <div class="assignment-badge">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="18" height="18">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"/>
                        </svg>
                    </div>
                    <div class="assignment-details">
                        <h4><?php echo htmlspecialchars($c['name']); ?></h4>
                        <p>Class Teacher Role</p>
                    </div>
                </div>
                <div class="assignment-id">ID: <?php echo htmlspecialchars($c['id']); ?></div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
    
    <div class="section-card">
        <div class="section-header">
            <div class="section-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/>
                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/>
                </svg>
            </div>
            <h2>Assigned as Subject Teacher</h2>
        </div>
        
        <?php if(count($subject_list)==0): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/>
                    <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/>
                </svg>
            </div>
            <h3>No Subject Assignments</h3>
            <p>You don't have any subject teaching assignments yet</p>
        </div>
        <?php else: ?>
        <div class="assignment-grid">
            <?php foreach($subject_list as $it): ?>
            <div class="assignment-item">
                <div class="assignment-info">
                    <div class="assignment-badge">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" width="18" height="18">
                            <path d="M2 3h6a4 4 0 0 1 4 4v14a3 3 0 0 0-3-3H2z"/>
                            <path d="M22 3h-6a4 4 0 0 0-4 4v14a3 3 0 0 1 3-3h7z"/>
                        </svg>
                    </div>
                    <div class="assignment-details">
                        <h4><?php echo htmlspecialchars($it['subject']['name']); ?></h4>
                        <p><?php echo htmlspecialchars($it['class']['name']); ?></p>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</div>
