<?php
// view_marks.php
if(!isset($_SESSION['teacher_id'])){
    echo "Not authorized";
    exit;
}
$tid = $_SESSION['teacher_id'];

$teach = mysqli_connect("localhost","thevkin_schlteachdb","VK_AutSchlDb","thevkin_schlteachdb");
$core  = mysqli_connect("localhost","thevkin_schlcoredb","VK_AutSchlDb","thevkin_schlcoredb");
if(!$teach || !$core) die("DB Error");

// Fetch classes assigned to teacher
$classes = [];
$qr = mysqli_query($teach,"SELECT DISTINCT class_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."'");
while($r=mysqli_fetch_assoc($qr)){
    $cid = mysqli_real_escape_string($core,$r['class_id']);
    $c = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM classes WHERE id='{$cid}'"));
    if($c) $classes[$c['id']] = $c['name'];
}

$selected_class = $_POST['class_id'] ?? '';
$selected_subject = $_POST['subject_id'] ?? '';
$term = $_POST['term'] ?? '';

$subjects_for_class = [];
if($selected_class){
    $sq = mysqli_query($teach,"SELECT subject_id FROM teacher_subject_assignments WHERE teacher_id='".mysqli_real_escape_string($teach,$tid)."' AND class_id='".mysqli_real_escape_string($teach,$selected_class)."'");
    while($r=mysqli_fetch_assoc($sq)){
        $sid = mysqli_real_escape_string($core,$r['subject_id']);
        $s = mysqli_fetch_assoc(mysqli_query($core,"SELECT id,name FROM subjects WHERE id='{$sid}'"));
        if($s) $subjects_for_class[$s['id']] = $s['name'];
    }
}

$marks_list = [];
if($selected_class && $selected_subject && $term){
    $rs = mysqli_query($core,"SELECT m.id as mark_id, m.student_id, m.marks, s.name as student_name
                               FROM marks m
                               JOIN students s ON m.student_id=s.id
                               WHERE m.subject_id='".mysqli_real_escape_string($core,$selected_subject)."'
                                 AND m.term='".mysqli_real_escape_string($core,$term)."'
                               ORDER BY s.name ASC");
    while($r=mysqli_fetch_assoc($rs)) $marks_list[] = $r;
}
?>
<style>
.view-marks-container {
    padding: 32px;
}

.filter-card {
    background: white;
    padding: 28px;
    border-radius: 12px;
    margin-bottom: 24px;
    border: 1px solid #e5e7eb;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    color: #374151;
    font-size: 14px;
}

.form-select,
.form-input {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e5e7eb;
    border-radius: 10px;
    font-size: 15px;
    background: white;
    transition: all 0.2s ease;
    font-family: 'Inter', sans-serif;
}

.form-select:focus,
.form-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
}

.btn-primary {
    padding: 12px 24px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
}

.marks-list-card {
    background: white;
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid #e5e7eb;
}

.marks-table {
    width: 100%;
    border-collapse: collapse;
}

.marks-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.marks-table th {
    padding: 16px;
    text-align: left;
    color: white;
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.marks-table tbody tr {
    border-bottom: 1px solid #f3f4f6;
    transition: all 0.2s ease;
}

.marks-table tbody tr:hover {
    background: #f9fafb;
}

.marks-table td {
    padding: 16px;
    color: #374151;
    font-size: 14px;
}

.marks-badge {
    display: inline-block;
    padding: 6px 14px;
    border-radius: 20px;
    font-weight: 500;
    font-size: 14px;
}

.marks-badge.high {
    background: #d1fae5;
    color: #065f46;
}

.marks-badge.medium {
    background: #fef3c7;
    color: #92400e;
}

.marks-badge.low {
    background: #fee2e2;
    color: #991b1b;
}

.btn-edit {
    padding: 6px 16px;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: white;
    border: none;
    border-radius: 6px;
    text-decoration: none;
    display: inline-block;
    transition: all 0.2s ease;
    font-size: 13px;
}

.btn-edit:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(59, 130, 246, 0.3);
}

.empty-state {
    text-align: center;
    padding: 64px 24px;
}

.empty-icon {
    width: 100px;
    height: 100px;
    background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.empty-icon svg {
    width: 50px;
    height: 50px;
    color: #9ca3af;
}

.empty-state h3 {
    font-size: 20px;
    color: #1f2937;
    margin-bottom: 8px;
}

.empty-state p {
    font-size: 15px;
    color: #6b7280;
}

@media (max-width: 768px) {
    .view-marks-container {
        padding: 20px;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .marks-table {
        min-width: 500px;
    }
    
    .marks-list-card {
        overflow-x: auto;
    }
}
</style>

<div class="view-marks-container">
    <div class="filter-card">
        <form method="post">
            <div class="form-grid">
                <div class="form-group">
                    <label for="class_id">Class</label>
                    <select name="class_id" id="class_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- Select Class --</option>
                        <?php foreach($classes as $id=>$n){ 
                            $sel=($id==$selected_class)?'selected':''; 
                            echo "<option value='".htmlspecialchars($id)."' $sel>".htmlspecialchars($n)."</option>"; 
                        } ?>
                    </select>
                </div>
                
                <?php if($selected_class): ?>
                <div class="form-group">
                    <label for="subject_id">Subject</label>
                    <select name="subject_id" id="subject_id" class="form-select" onchange="this.form.submit()" required>
                        <option value="">-- Select Subject --</option>
                        <?php foreach($subjects_for_class as $sid=>$sname){ 
                            $sel=($sid==$selected_subject)?'selected':''; 
                            echo "<option value='".htmlspecialchars($sid)."' $sel>".htmlspecialchars($sname)."</option>"; 
                        } ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="term">Term</label>
                    <input type="text" id="term" name="term" class="form-input" value="<?php echo htmlspecialchars($term); ?>" placeholder="e.g. Midterm">
                </div>
                <?php endif; ?>
            </div>
            
            <?php if($selected_class): ?>
            <button type="submit" class="btn-primary">Show Marks</button>
            <?php endif; ?>
        </form>
    </div>
    
    <?php if(count($marks_list)): ?>
    <div class="marks-list-card">
        <table class="marks-table">
            <thead>
                <tr>
                    <th>Student Name</th>
                    <th>Marks</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($marks_list as $m): 
                    $marks = intval($m['marks']);
                    $badge_class = $marks >= 70 ? 'high' : ($marks >= 40 ? 'medium' : 'low');
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($m['student_name']); ?></td>
                    <td><span class="marks-badge <?php echo $badge_class; ?>"><?php echo htmlspecialchars($m['marks']); ?></span></td>
                    <td>
                        <a class="btn-edit" href="edit_marks.php?mark_id=<?php echo urlencode($m['mark_id']); ?>">
                            Edit
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php elseif($selected_class && $selected_subject && $term): ?>
    <div class="empty-state">
        <div class="empty-icon">
            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <path d="M9 11l3 3L22 4"/>
                <path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/>
            </svg>
        </div>
        <h3>No Marks Found</h3>
        <p>No marks have been recorded for this selection</p>
    </div>
    <?php endif; ?>
</div>
